<?php

/**
 * Provide a admin-facing view for the Attribute Fields form of the plugin
 *
 * This file is used to markup the admin-facing attribute form of the plugin admin side.
 *
 * @link       https://staggs.app
 * @since      1.5.0
 *
 * @package    Staggs
 * @subpackage Staggs/admin/fields
 */

if ( ! function_exists( 'acf_add_local_field_group' ) ) {
	return;
}

acf_add_local_field_group( array(
	'key' => 'group_64c2db68a85ef',
	'title' => 'Attribute details',
	'fields' => array(
		array(
			'key' => 'field_64d28b14a7660',
			'label' => 'General',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64c2db699e96f',
			'label' => 'Title',
			'name' => 'sgg_step_title',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'This title as shown in the product configurator.',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2dbf0c2572',
			'label' => 'Template',
			'name' => 'sgg_step_template',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Select how your attributes will be displayed.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'dropdown' => 'Dropdown',
				'options' => 'Options list',
				'cards' => 'Cards',
				'icons' => 'Image swatches',
				'swatches' => 'Color swatches',
				'button-group' => 'Button group',
				'tickboxes' => 'Tickboxes',
				'true-false' => 'True / False',
				'text-input' => 'Text input',
				'number-input' => 'Number input',
				'measurements' => 'Measurements',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2dc6ec2573',
			'label' => 'Type',
			'name' => 'sgg_attribute_type',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Select attribute type to be used in the template. <a href="https://staggs.app/attribute-support-table" target="_blank">View attribute support table</a>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'image' => 'Image',
				'input' => 'Input',
				'color' => 'Color',
				'font' => 'Font',
				'url'  => 'URL',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64e3144f3bbf0',
			'label' => 'Required field',
			'name' => 'sgg_step_field_required',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Select if the attribute is required or optional.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'no' => 'Optional',
				'yes' => 'Required',
			),
			'default_value' => 'no',
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64e3144f3bbf1',
			'label' => 'Dropdown placeholder',
			'name' => 'sgg_step_field_placeholder',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally override placeholder text. Defaults to "- field label -"',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'dropdown',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2e306c25a5',
			'label' => 'Options',
			'name' => 'sgg_attribute_items',
			'aria-label' => '',
			'type' => 'repeater',
			'instructions' => 'Create your attribute options.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => 'sgg_attribute_items',
				'id' => '',
			),
			'layout' => 'block',
			'pagination' => 1,
			'rows_per_page' => 20,
			'min' => 0,
			'max' => 0,
			'collapsed' => 'field_64c2e319c25a6',
			'button_label' => 'Add option',
			'sub_fields' => array(
				array(
					'key' => 'field_64c54127fa062',
					'label' => 'General',
					'name' => '',
					'aria-label' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c2e319c25a6',
					'label' => 'Label',
					'name' => 'sgg_option_label',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Main attribute label.',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c2e32fc25a7',
					'label' => 'Note',
					'name' => 'sgg_option_note',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Note is displayed underneath the label.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'options',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'cards',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'icons',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'swatches',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'tickboxes',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'text-input',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'number-input',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'measurements',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c541b1fa063',
					'label' => 'Thumbnail',
					'name' => 'sgg_option_image',
					'aria-label' => '',
					'type' => 'image',
					'instructions' => 'Note: please keep image sizes lower than 2 MB to maintain the configurator performance.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'options',
							),
							array(
								'field' => 'field_64c2dd7ec257b',
								'operator' => '==',
								'value' => 'show',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'cards',
							),
							array(
								'field' => 'field_64c2dd7ec257b',
								'operator' => '==',
								'value' => 'show',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'icons',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'id',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
					'preview_size' => 'thumbnail',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c541fcfa067',
					'label' => 'Input Type',
					'name' => 'sgg_option_field_type',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Select your input type.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'text' => 'Text',
						'textarea' => 'Textarea',
						'date' => 'Date picker',
						'number' => 'Number',
						'range' => 'Range slider',
						'file' => 'File',
					),
					'default_value' => false,
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c547266d863',
					'label' => 'Placeholder',
					'name' => 'sgg_option_field_placeholder',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Optionally set a placeholder for the input.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '!=',
								'value' => 'range',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '!=',
								'value' => 'file',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c5478e6d868',
					'label' => 'Value',
					'name' => 'sgg_option_field_value',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Optionally set a default value for the input.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '!=',
								'value' => 'date',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '!=',
								'value' => 'file',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64e0a7a22d05a',
					'label' => 'Show datepicker icon',
					'name' => 'sgg_option_datepicker_show_icon',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Icon can be managed under Settings.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '==',
								'value' => 'date',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64e0a7ef2d05b',
					'label' => 'Show datepicker inline',
					'name' => 'sgg_option_datepicker_show_inline',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Replaces the input field with the inline datepicker.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '==',
								'value' => 'date',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c547ae6d869',
					'label' => 'Color',
					'name' => 'sgg_option_field_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => 'Pick a color value.',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'color',
							),
						),
						array(
							array(
								'field' => 'field_64c2dbf0c2572',
								'operator' => '==',
								'value' => 'swatches',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'enable_opacity' => 0,
					'return_format' => 'string',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c544acfa083',
					'label' => 'Font Stylesheet URL',
					'name' => 'sgg_option_font_source',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Link to Google Fonts or Adobe Typekit font stylesheet.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'font',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c544c7fa084',
					'label' => 'Font Family',
					'name' => 'sgg_option_font_family',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Font family as defined in CSS (e.g. "Helvetica", sans-serif")',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'font',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c544d7fa085',
					'label' => 'Font Weight',
					'name' => 'sgg_option_font_weight',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'Font weight as numeric value (e.g. 400, 700, 900)',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'font',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'min' => '',
					'max' => '',
					'placeholder' => '',
					'step' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c549ea874a1',
					'label' => 'Price type',
					'name' => 'sgg_option_calc_price_type',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Items marked with option support user selection fields. Items marked with input support user input fields.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'single' => 'Fixed price (option, input)',
						'unit' => 'Unit price (input)',
					),
					'default_value' => false,
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c549ea874b4',
					'label' => '',
					'name' => 'sgg_option_price_message',
					'aria-label' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '!=',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c549ea874a1',
								'operator' => '==',
								'value' => 'unit',
							),
						),
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '!=',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c549ea874a1',
								'operator' => '==',
								'value' => 'table',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => 'This combination of attribute type and price type is not supported',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c54aa0874a5',
					'label' => 'Price per unit',
					'name' => 'sgg_option_calc_price_value',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Define fixed price per unit value. Important! Units should match.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c549ea874a1',
								'operator' => '==',
								'value' => 'unit',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c54ac1874a6',
					'label' => 'Price',
					'name' => 'sgg_option_price',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Additional cost for this attribute item. Leave empty for no additional cost.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c549ea874a1',
								'operator' => '==',
								'value' => 'single',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c54b2e874ac',
					'label' => 'Sale Price',
					'name' => 'sgg_option_sale_price',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Discounted additional cost for this attribute item. Must be lower than price.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c549ea874a1',
								'operator' => '==',
								'value' => 'single',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c54612fa093',
					'label' => 'Field',
					'name' => '',
					'aria-label' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c5450bfa086',
					'label' => 'Field key',
					'name' => 'sgg_option_field_key',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Unique identifier for given field. Can be used for price calculations or input value previews.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c2e199c259a',
								'operator' => '==',
								'value' => 'image',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c5426cfa06b',
					'label' => 'Required field',
					'name' => 'sgg_option_field_required',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Select if the input field is required or optional.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'no' => 'Optional',
						'yes' => 'Required',
					),
					'default_value' => false,
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c546a76d85d',
					'label' => 'Range increments',
					'name' => 'sgg_option_range_increments',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Amount of increments per step. Defaults to 1.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '==',
								'value' => 'range',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64e0a7502d059',
					'label' => 'Date format',
					'name' => 'sgg_option_datepicker_format',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Set a date format for the date picker. Defaults to mm/dd/yy',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '==',
								'value' => 'date',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c546c86d85e',
					'label' => 'Field min',
					'name' => 'sgg_option_field_min',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Minimum text length, date or numeric value for given field.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '!=',
								'value' => 'file',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c546e96d85f',
					'label' => 'Field max',
					'name' => 'sgg_option_field_max',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Maximum text length, date or numeric value for given field.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '!=',
								'value' => 'file',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c546f76d860',
					'label' => 'Field unit',
					'name' => 'sgg_option_field_unit',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Optionally display unit for given field (e.g. cm, inch, gallon, liters)',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '==',
								'value' => 'number',
							),
						),
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '==',
								'value' => 'range',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c541b5fa064',
					'label' => 'Preview',
					'name' => '',
					'aria-label' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c5478e6d869',
					'label' => 'Page URL',
					'name' => 'sgg_option_page_url',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Enter full URL of page you want to link to.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'url',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c542c9fa06d',
					'label' => 'Enable Preview',
					'name' => 'sgg_option_enable_preview',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'If enabled, the input value/image will be displayed/updated in the product preview.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'yes' => 'Yes',
						'no' => 'No',
					),
					'default_value' => false,
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c542f0fa06e',
					'label' => 'Main Images',
					'name' => 'sgg_option_preview',
					'aria-label' => '',
					'type' => 'gallery',
					'instructions' => 'Choose main images to show when this step option is selected. Note: please keep image sizes lower than 2 MB to maintain the configurator performance.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'image',
							),
							array(
								'field' => 'field_64c542c9fa06d',
								'operator' => '==',
								'value' => 'yes',
							),
						),
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'color',
							),
							array(
								'field' => 'field_64c542c9fa06d',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'id',
					'library' => 'all',
					'min' => '',
					'max' => '',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
					'insert' => 'append',
					'preview_size' => 'medium',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c54390fa07a',
					'label' => 'Preview Top Position',
					'name' => 'sgg_option_preview_top',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Set default preview position from top. Use CSS Units.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c2e199c259a',
								'operator' => '==',
								'value' => 'image',
							),
							array(
								'field' => 'field_64c542c9fa06d',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '50%',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c543c8fa07b',
					'label' => 'Preview Left Position',
					'name' => 'sgg_option_preview_left',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Set default preview position from left. Use CSS Units.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c2e199c259a',
								'operator' => '==',
								'value' => 'image',
							),
							array(
								'field' => 'field_64c542c9fa06d',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '50%',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c543c8fa07c',
					'label' => 'Preview Width',
					'name' => 'sgg_option_preview_width',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Optionally set a preview width. Use CSS Units.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c2e199c259a',
								'operator' => '==',
								'value' => 'image',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '!=',
								'value' => 'file',
							),
							array(
								'field' => 'field_64c542c9fa06d',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c543e2fa07c',
					'label' => 'Preview Top (Mobile)',
					'name' => 'sgg_option_preview_top_mobile',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Set default preview position from top. Use CSS Units.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c2e199c259a',
								'operator' => '==',
								'value' => 'image',
							),
							array(
								'field' => 'field_64c542c9fa06d',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '50%',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c543f8fa07d',
					'label' => 'Preview Left (Mobile)',
					'name' => 'sgg_option_preview_left_mobile',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Set default preview position from left. Use CSS Units.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c2e199c259a',
								'operator' => '==',
								'value' => 'image',
							),
							array(
								'field' => 'field_64c542c9fa06d',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '50%',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c543c8fa07e',
					'label' => 'Preview Width (Mobile)',
					'name' => 'sgg_option_preview_width_mobile',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Optionally set a preview width. Use CSS Units.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2dc6ec2573',
								'operator' => '==',
								'value' => 'input',
							),
							array(
								'field' => 'field_64c2e199c259a',
								'operator' => '==',
								'value' => 'image',
							),
							array(
								'field' => 'field_64c541fcfa067',
								'operator' => '!=',
								'value' => 'file',
							),
							array(
								'field' => 'field_64c542c9fa06d',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
				array(
					'key' => 'field_64c544d7fa08a',
					'label' => 'Preview Reference Selector',
					'name' => 'sgg_option_preview_ref_selector',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Enter corresponding CSS property values.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64c2e246c25a0',
								'operator' => '!=',
								'value' => '',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'min' => '',
					'max' => '',
					'placeholder' => '',
					'step' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64c2e306c25a5',
				),
			),
		),
		array(
			'key' => 'field_64d28b24a7661',
			'label' => 'Presentation',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64c2dbbfc2570',
			'label' => 'Short description',
			'name' => 'sgg_step_short_description',
			'aria-label' => '',
			'type' => 'wysiwyg',
			'instructions' => 'Short description as shown below the title',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'tabs' => 'all',
			'toolbar' => 'full',
			'media_upload' => 1,
			'delay' => 0,
		),
		array(
			'key' => 'field_64c2dbd5c2571',
			'label' => 'Long description',
			'name' => 'sgg_step_description',
			'aria-label' => '',
			'type' => 'wysiwyg',
			'instructions' => 'Extensive description that will be displayed in pop-up or side panel.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'tabs' => 'all',
			'toolbar' => 'full',
			'media_upload' => 1,
			'delay' => 0,
		),
		array(
			'key' => 'field_64c2dccac2579',
			'label' => 'Custom class',
			'name' => 'sgg_step_custom_class',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally enter custom HTML class(es) for the attribute.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2dccac2575',
			'label' => 'Shared group',
			'name' => 'sgg_step_shared_group',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Share attribute options with other attributes with same name.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'options',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'cards',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'icons',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'swatches',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'button-group',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2dc93c2574',
			'label' => 'Show field info',
			'name' => 'sgg_step_field_info',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Show min/max field value info label underneath input fields.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dc6ec2573',
						'operator' => '==',
						'value' => 'input',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'yes' => 'Display field info labels',
				'no' => 'Hide field info labels',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2dd5bc257a',
			'label' => 'Style',
			'name' => 'sgg_step_style',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Modify the style setting for individual attributes display',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'inherit' => 'Inherit from theme',
				'rounded' => 'Rounded',
				'squared' => 'Squared',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2dde2c257e',
			'label' => 'Cards width',
			'name' => 'sgg_step_option_layout',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose to show 2 or 3 cards next to each other.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'cards',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'two' => __( '2 cards per row', 'staggs' ),
				'three' => __( '3 cards per row', 'staggs' ),
				'four' => __( '4 cards per row', 'staggs' ),
				'five' => __( '5 cards per row', 'staggs' ),
				'six' => __( '6 cards per row', 'staggs' ),
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2de0cc257f',
			'label' => 'Card template',
			'name' => 'sgg_step_card_template',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose to show image inside card or not.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'cards',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'default' => 'Show image inside card',
				'full' => 'Show image on top of card',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2dd7ec257b',
			'label' => 'Display thumbnails',
			'name' => 'sgg_step_show_image',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Display thumbnails in options',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'options',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'cards',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'product',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'show' => 'Show thumbnails',
				'hide' => 'Hide thumbnails',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2de3cc2581',
			'label' => 'Display summary',
			'name' => 'sgg_step_show_summary',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Display summary of selected option.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'dropdown',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'options',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'cards',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'icons',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'swatches',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'button-group',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'show' => 'Show summary',
				'hide' => 'Hide summary',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2de3cc2582',
			'label' => 'Display title',
			'name' => 'sgg_step_show_title',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose to show or hide attribute title.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'show' => 'Show title',
				'hide' => 'Hide title',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2de3cc2583',
			'label' => 'Display input labels',
			'name' => 'sgg_step_show_input_label',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose to show or hide input field labels.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'text-input',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'number-input',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'measurements',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'image-upload',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'show' => 'Show attribute input labels',
				'hide' => 'Hide attribute input labels',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2de6ac2532',
			'label' => 'Enable tick all options',
			'name' => 'sgg_step_show_tick_all',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Display button to (de)select all options at once.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'tickboxes',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'hide' => 'Hide tick all option',
				'show' => 'Show tick all option',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2de6ac2539',
			'label' => 'Tick all options label',
			'name' => 'sgg_step_tick_all_label',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Label to display in tick all option.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'tickboxes',
					),
					array(
						'field' => 'field_64c2de6ac2532',
						'operator' => '==',
						'value' => 'show',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64e3144f3bbf8',
			'label' => 'Display option price',
			'name' => 'sgg_step_show_option_price',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Optionally choose to hide prices for the customer.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'show' => 'Show prices',
				'hide' => 'Hide prices',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2de6ac2582',
			'label' => 'Choose swatch size',
			'name' => 'sgg_step_swatch_size',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose the size of your swatches.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'icons',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'swatches',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'inherit' => 'Default',
				'small' => 'Small',
				'regular' => 'Regular',
				'medium' => 'Medium',
				'large' => 'Large',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2deb3c2584',
			'label' => 'Swatch border position',
			'name' => 'sgg_step_swatch_style',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose to show border inside or outside when checked.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'icons',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'swatches',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'outside' => 'Outside',
				'inside' => 'Inside',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2dedfc2585',
			'label' => 'Display inline swatch label',
			'name' => 'sgg_step_show_swatch_label',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Shows label of swatch inline.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'icons',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'swatches',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'hide' => 'Hide inline labels',
				'show' => 'Show inline labels',
				'show_note' => 'Show inline notes',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2defec2586',
			'label' => 'Display swatch tooltip',
			'name' => 'sgg_step_show_tooltip',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Show tooltip with value on hover.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'icons',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'swatches',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'show' => 'Show tooltip',
				'hide' => 'Hide tooltip',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2df21c2587',
			'label' => 'Tooltip display',
			'name' => 'sgg_step_tooltip_template',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose what is included in the tooltip.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'icons',
					),
					array(
						'field' => 'field_64c2defec2586',
						'operator' => '==',
						'value' => 'show',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'swatches',
					),
					array(
						'field' => 'field_64c2defec2586',
						'operator' => '==',
						'value' => 'show',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'simple' => 'Show label and price',
				'extended' => 'Show icon, label and price',
				'text' => 'Show label, note and price',
				'full' => 'Show icon, label, note and price',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2df21c2589',
			'label' => 'Enable zoom function',
			'name' => 'sgg_step_enable_zoom',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Show zoom icon on hover to enlarge the image',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'options',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'cards',
					),
				),
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'icons',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'hide' => 'No zoom function',
				'show' => 'Enable zoom function',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2dfaec258c',
			'label' => 'Button view',
			'name' => 'sgg_step_button_view',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Select how you want the true-false option to be displayed',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'true-false',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'button' => 'Button',
				'toggle' => 'Toggle',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2dfdac258d',
			'label' => 'Button add text',
			'name' => 'sgg_step_button_add',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter text when option is not selected.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'true-false',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2e002c258e',
			'label' => 'Button remove text',
			'name' => 'sgg_step_button_del',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter text when option is selected.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2dbf0c2572',
						'operator' => '==',
						'value' => 'true-false',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64d28b14a7662',
			'label' => 'Gallery',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64c2e199c259a',
			'label' => 'Gallery type',
			'name' => 'sgg_gallery_type',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Define configurator gallery type.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'image' => 'Image',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2e1d3c259b',
			'label' => 'Image Layer Order',
			'name' => 'sgg_step_preview_order',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => 'Higher numbers will be displayed on top.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e199c259a',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'min' => '',
			'max' => '',
			'placeholder' => '',
			'step' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2e1f1c259c',
			'label' => 'Display Images On Slides',
			'name' => 'sgg_step_preview_index',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Slides the main image will appear on. Defaults to first slide (1).',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e199c259a',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => 'e.g. 1, 2, 5',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2e22ac259f',
			'label' => 'Make Slide Active',
			'name' => 'sgg_step_preview_slide',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => 'Index of product image slide to show when viewing this step.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e199c259a',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'min' => '',
			'max' => '',
			'placeholder' => '',
			'step' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2e246c25a0',
			'label' => 'Gallery Preview Reference',
			'name' => 'sgg_step_preview_ref',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Gallery preview reference. Use for text or image preview updates (supports comma separated values)',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e199c259a',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2e246c25a1',
			'label' => 'Gallery Preview Properties:',
			'name' => 'sgg_step_preview_ref_props',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter preview CSS properties, like color, width or height (supports comma separated values)',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e199c259a',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2e199c259d',
			'label' => 'Gallery Preview Bundle',
			'name' => 'sgg_step_preview_bundle',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'This will bundle all input previews together in the first defined position.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e199c259a',
						'operator' => '==',
						'value' => 'image',
					),
					array(
						'field' => 'field_64c2dc6ec2573',
						'operator' => '==',
						'value' => 'input',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'no' => 'No',
				'yes' => 'Yes',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2e199c259e',
			'label' => 'Gallery Preview Height',
			'name' => 'sgg_step_preview_height',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally define the allowed height of all input previews together. Use CSS units.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e199c259a',
						'operator' => '==',
						'value' => 'image',
					),
					array(
						'field' => 'field_64c2dc6ec2573',
						'operator' => '==',
						'value' => 'input',
					),
					array(
						'field' => 'field_64c2e199c259d',
						'operator' => '==',
						'value' => 'yes',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64d28b14a7661',
			'label' => 'Advanced Calculation',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64c2e012c258f',
			'label' => 'Price type',
			'name' => 'sgg_step_calc_price_type',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose matrix to pick a price based on two values (pro).',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'none' => 'No calculation',
				'formula' => 'Formula',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2e086c2599',
			'label' => 'Price key',
			'name' => 'sgg_step_calc_price_key',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally set price key to use in the total price calculation formula.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e012c258f',
						'operator' => '==',
						'value' => 'formula',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2e086c2680',
			'label' => 'Price label',
			'name' => 'sgg_step_calc_price_label',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally set price label to show calculated price to user in configuration form.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e012c258f',
						'operator' => '==',
						'value' => 'formula',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64c2e086c2690',
			'label' => 'Price label position',
			'name' => 'sgg_step_calc_price_label_position',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose to show price label and calculated price above or below the field.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e012c258f',
						'operator' => '==',
						'value' => 'formula',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'above' => 'Above attribute field',
				'below' => 'Below attribute field',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64c2e086c2591',
			'label' => 'Formula',
			'name' => 'sgg_step_price_formula',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Describe formula of field keys for price calculation (e.g. A + B * C).',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64c2e012c258f',
						'operator' => '==',
						'value' => 'formula',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'sgg_attribute',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );
