<?php

/**
 * Provide a admin-facing view for the Staggs Theme form of the plugin
 *
 * This file is used to markup the admin-facing theme form of the plugin admin side.
 *
 * @link       https://staggs.app
 * @since      1.5.0
 *
 * @package    Staggs
 * @subpackage Staggs/admin/fields
 */

 if ( ! function_exists( 'acf_add_local_field_group' ) ) {
	return;
}

acf_add_local_field_group( array(
	'key' => 'group_64c90e2adf93a',
	'title' => 'Staggs Configurator Template',
	'fields' => array(
		array(
			'key' => 'field_64c90e2b0f0b7',
			'label' => 'Template',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce3a04d11b1',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Template</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64df9e82041d8',
			'label' => 'Gallery type',
			'name' => 'sgg_configurator_gallery_type',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'regular' => 'Image',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64ce39a4d11af',
			'label' => 'Staggs Configurator template',
			'name' => 'sgg_configurator_page_template',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => 'Set to WooCommerce Page Template to use your theme\\\'s product page or default WooCommerce Product Page template',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'staggs' => 'Staggs Product Configurator Template',
				'default' => 'WooCommerce Page Template',
				'none' => 'Attributes Only Template',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce39d7d11b0',
			'label' => 'Disable default Staggs configurator styles',
			'name' => 'sgg_disable_attribute_styles',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce39a4d11af',
						'operator' => '!=',
						'value' => 'staggs',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce3a70671de',
			'label' => 'Template',
			'name' => 'sgg_configurator_view',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce39a4d11af',
						'operator' => '==',
						'value' => 'staggs',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'classic' => 'Classic Template',
				'floating' => 'Floating Template',
				'full' => 'Full Template',
				'popup' => 'Popup Template',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4b39cc613',
			'label' => 'Configurator popup button text',
			'name' => 'sgg_step_popup_button_text',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'popup',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4b2fcc619',
			'label' => 'Show contents of popup inline on mobile',
			'name' => 'sgg_configurator_popup_mobile_inline',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Disable sticky elements in popup on mobile view (natural scroll)',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'popup',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4d19cc61d',
			'label' => 'Set included option label',
			'name' => 'sgg_step_set_included_option_text',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4d34cc61e',
			'label' => 'Included option text',
			'name' => 'sgg_step_included_text',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter text to display when option is included in base price.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d19cc61d',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4d19cc61e',
			'label' => 'Disable default option selection on load',
			'name' => 'sgg_step_disable_default_option',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Disables the automatic selection of the first available option on configurator load',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce40bdf7d86',
			'label' => 'Disable add to cart button styles',
			'name' => 'sgg_theme_disable_cart_styles',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'This setting overrides the default Staggs template styles for add to cart button.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4a97cc60a',
			'label' => 'Template options',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce4aa2cc60b',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Template options</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce4ab8cc60c',
			'label' => 'Header and footer display',
			'name' => 'sgg_show_theme_header_footer',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'floating',
					),
				),
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'full',
					),
				),
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'steps',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'none' => 'Hide header and footer',
				'both' => 'Show header and footer',
				'header' => 'Show header only',
				'footer' => 'Show footer only',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3cddab4d2',
			'label' => 'Layout',
			'name' => 'sgg_configurator_layout',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'right' => 'Image Preview Right',
				'left' => 'Image Preview Left',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3d51ab4d6',
			'label' => 'Text Align',
			'name' => 'sgg_configurator_text_align',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'center' => 'Center',
				'left' => 'Left',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3d63ab4d7',
			'label' => 'Borders',
			'name' => 'sgg_configurator_borders',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'rounded' => 'Rounded',
				'squared' => 'Squared',
				'pill' => 'Circular',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3d63ab4d8',
			'label' => 'Description type',
			'name' => 'sgg_configurator_step_description_type',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'panel' => 'Panel',
				'popup' => 'Popup',
				'tooltip' => 'Tooltip',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4b00cc60f',
			'label' => 'Show company logo',
			'name' => 'sgg_show_logo',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b00cc60g',
			'label' => 'Show company logo in options panel',
			'name' => 'sgg_show_logo_options',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Displays the company logo above the title.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4b00cc60f',
						'operator' => '==',
						'value' => '1',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'classic',
					),
				),
				array(
					array(
						'field' => 'field_64ce4b00cc60f',
						'operator' => '==',
						'value' => '1',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'floating',
					),
				),
				array(
					array(
						'field' => 'field_64ce4b00cc60f',
						'operator' => '==',
						'value' => '1',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'full',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b1bcc609',
			'label' => 'Disable Staggs floating add to cart notices',
			'name' => 'sgg_configurator_disable_floating_notice',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b1bcc610',
			'label' => 'Disable WooCommerce product price',
			'name' => 'sgg_configurator_disable_product_price',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b1bcc611',
			'label' => 'Disable updating the single WooCommerce Product Price',
			'name' => 'sgg_configurator_disable_product_price_update',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Updates the default WooCommerce Single Product price to match the total configuration price by default.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4b1bcc610',
						'operator' => '==',
						'value' => '0',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b26cc611',
			'label' => 'Disable WooCommerce product meta (SKU, Category)',
			'name' => 'sgg_configurator_disable_product_meta',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b1fcd609',
			'label' => 'Disable Staggs WooCommerce product tabs override',
			'name' => 'sgg_configurator_disable_product_tabs_override',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Enable this option if you do not want the tabs to be relocated.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b2fcc612',
			'label' => 'Disable WooCommerce product tabs',
			'name' => 'sgg_configurator_disable_product_tabs',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b2fcc613',
			'label' => 'Disable WooCommerce Template Override',
			'name' => 'sgg_configurator_disable_template_override',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Only applicable when you want to output the configurator contents using shortcode(s)',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b2fcde01',
			'label' => 'Show close button',
			'name' => 'sgg_show_close_button',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '!=',
						'value' => 'popup',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b2fcde02',
			'label' => 'Back page URL',
			'name' => 'sgg_back_page_url',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Configure logo / back button URL. Defaults to home URL.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4b00cc60f',
						'operator' => '==',
						'value' => '1',
					),
				),
				array(
					array(
						'field' => 'field_64ce4b00cc60g',
						'operator' => '==',
						'value' => '1',
					),
				),
				array(
					array(
						'field' => 'field_64ce4b2fcde01',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4b2fcde03',
			'label' => 'Show close button confirm message',
			'name' => 'sgg_show_close_button_message',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4b2fcde01',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b2fcde04',
			'label' => 'Close button confirm message',
			'name' => 'sgg_close_button_message',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4b2fcde03',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce3cc2d6ddb',
			'label' => 'Gallery',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce3cc2d6ddc',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Gallery</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce3d1cab444',
			'label' => 'Template height',
			'name' => 'sgg_configurator_template_height',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'full_height' => 'Force full height of screen on desktop',
				'image_height' => 'Use image height as reference for configurator height',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4b2fcc64a',
			'label' => 'Block mobile gallery image overflow',
			'name' => 'sgg_gallery_scale_mobile_display',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce3d77ab4d9',
			'label' => 'Make Gallery Image Sticky',
			'name' => 'sgg_configurator_gallery_sticky',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Keep image preview in view when scrolling down the options list.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'classic',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4ba7cc616',
			'label' => 'Gallery display on mobile devices',
			'name' => 'sgg_mobile_gallery_display',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '!=',
						'value' => 'popup',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'fixed' => 'Fixed at the top',
				'inline' => 'Inline',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4b39cc615',
			'label' => 'Fixed mobile header offset',
			'name' => 'sgg_configurator_fixed_header_height',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter offset of mobile header in pixels. (Enter numeric value)',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4ba7cc616',
						'operator' => '==',
						'value' => 'fixed',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '!=',
						'value' => 'popup',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce3d1cab4d4',
			'label' => 'Preview Type',
			'name' => 'sgg_preview_image_type',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'stacked' => 'Stacked Image Preview',
				'single' => 'Single Image Preview',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3d77ab4d8',
			'label' => 'Display product featured image',
			'name' => 'sgg_use_product_image',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Use the product featured image as the base layer for the preview.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3d1cab4d4',
						'operator' => '==',
						'value' => 'stacked',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5c3cef557',
			'label' => 'Generate active configuration image for cart',
			'name' => 'sgg_configurator_generate_cart_image',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Product featured image will be shown by default.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5c65ef558',
			'label' => 'Store configuration previews in uploads folder for later access',
			'name' => 'sgg_configurator_store_cart_image',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce5c3cef557',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce3cc2d9ddb',
			'label' => 'Gallery background',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce3cc2d9ddc',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Gallery background</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce3bf3d6dd9',
			'label' => 'Add Background Image',
			'name' => 'sgg_show_bg_image',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce39a4d11af',
						'operator' => '==',
						'value' => 'staggs',
					),
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce3c1fd6dda',
			'label' => 'Background Image',
			'name' => 'sgg_bg_image',
			'aria-label' => '',
			'type' => 'gallery',
			'instructions' => 'Select one or more background images. Note: please keep image sizes lower than 2 MB to maintain the configurator performance.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce39a4d11af',
						'operator' => '==',
						'value' => 'staggs',
					),
					array(
						'field' => 'field_64ce3bf3d6dd9',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'id',
			'library' => 'all',
			'min' => '',
			'max' => '',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '.jpg, .jpeg, .png, .eps, .webp, .tiff, .svg',
			'insert' => 'append',
			'preview_size' => 'medium',
		),
		array(
			'key' => 'field_64ce3d34ab4d5',
			'label' => 'Background Image Size',
			'name' => 'sgg_bg_image_size',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'contain' => 'Contain',
				'cover' => 'Cover',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3c1fd6ddb',
			'label' => 'Stretch Background Image Behind Options',
			'name' => 'sgg_stretch_bg_image',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'floating',
					),
					array(
						'field' => 'field_64ce3bf3d6dd9',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce3c1fd6dd9',
			'label' => 'Capture Background Image In Export',
			'name' => 'sgg_capture_bg_image',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce39a4d11af',
						'operator' => '==',
						'value' => 'staggs',
					),
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
					array(
						'field' => 'field_64ce3bf3d6dd9',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce3ccee9ddb',
			'label' => 'Gallery controls',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce3ccee9ddc',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Gallery controls</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce4b2fcc65a',
			'label' => 'Display button to show gallery fullscreen',
			'name' => 'sgg_gallery_fullscreen_display',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b2fcc65b',
			'label' => 'Display button to capture configuration image',
			'name' => 'sgg_gallery_camera_display',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4b2fcc65f',
			'label' => 'Display button to reset configuration',
			'name' => 'sgg_gallery_reset_display',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce3daeab4d9',
			'label' => 'Display Gallery Thumbnails',
			'name' => 'sgg_configurator_thumbnails',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'none' => 'None',
				'thumbnails' => 'Thumbnails',
				'labels' => 'Labels',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3dc2ab4da',
			'label' => 'Gallery Thumbnails Align',
			'name' => 'sgg_configurator_thumbnails_align',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'left' => 'Left',
				'center' => 'Center',
				'right' => 'Right',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3dc2ab4db',
			'label' => 'Gallery Thumbnails Position',
			'name' => 'sgg_configurator_thumbnails_position',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_64ce3daeab4d9',
						'operator' => '==',
						'value' => 'thumbnails',
					),
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'inside' => 'Inside main image',
				'under' => 'Underneath main image',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3dc2ab4de',
			'label' => 'Gallery Thumbnails Layout',
			'name' => 'sgg_configurator_thumbnails_layout',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_64ce3daeab4d9',
						'operator' => '==',
						'value' => 'thumbnails',
					),
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
					array(
						'field' => 'field_64ce3dc2ab4db',
						'operator' => '==',
						'value' => 'under',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'inline' => 'Single row of images',
				'grid' => 'Image grid'
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3ddbab4db',
			'label' => 'Gallery Thumbnail Labels',
			'name' => 'sgg_configurator_thumbnail_labels',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter labels in comma-separated format for the image views (e.g. front, back, inside, top)',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3daeab4d9',
						'operator' => '==',
						'value' => 'labels',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce3dfaab4dc',
			'label' => 'Preview arrow controls',
			'name' => 'sgg_configurator_arrows',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64df9e82041d8',
						'operator' => '==',
						'value' => 'regular',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'none' => 'None',
				'bottom_right' => 'Bottom right',
				'bottom_left' => 'Bottom left',
				'center' => 'Center',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3ebfab4e1',
			'label' => 'Colors',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce3ed7ab4e3',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Colors</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce3ecdab4e2',
			'label' => 'Color theme',
			'name' => 'sgg_configurator_theme',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'light' => 'Light Theme',
				'dark' => 'Dark Theme',
				'custom' => 'Custom Theme',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3fc8f7d81',
			'label' => 'Accent Color',
			'name' => 'sgg_accent_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'General accent color for configurator elements',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#000000',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3fc8f7d31',
			'label' => 'Accent Hover Color',
			'name' => 'sgg_accent_hover_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'General hover color for configurator elements',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#000000',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3ffaf7d82',
			'label' => 'Button Text Color',
			'name' => 'sgg_button_text_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'General text color for configurator buttons to complement the accent color',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#FFFFFF',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3ffaf7d52',
			'label' => 'Button Hover Text Color',
			'name' => 'sgg_button_hover_text_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'General text hover color for configurator buttons to complement the accent color',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#FFFFFF',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f94ab4e8',
			'label' => 'Icon theme',
			'name' => 'sgg_configurator_icon_theme',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'light' => 'Light icons',
				'dark' => 'Dark icons',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3f00ab4e4',
			'label' => 'Primary color',
			'name' => 'sgg_primary_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'Options panel background color',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f16ab4e5',
			'label' => 'Secondary color',
			'name' => 'sgg_secondary_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'Image view background color',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f62ab4e6',
			'label' => 'Heading color',
			'name' => 'sgg_heading_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f7cab4e7',
			'label' => 'Text color',
			'name' => 'sgg_text_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f16ab4e7',
			'label' => 'Options Background',
			'name' => 'sgg_tertiary_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'Options cards background color',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f16ab4f3',
			'label' => 'Options Hover Background',
			'name' => 'sgg_tertiary_hover_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'Options background hover color',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f16ab4f4',
			'label' => 'Options Border Color',
			'name' => 'sgg_tertiary_border_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'Options border color',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f16ab4f5',
			'label' => 'Options Text Color',
			'name' => 'sgg_tertiary_text_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'Options text color',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f16ab4f6',
			'label' => 'Options Selected Background',
			'name' => 'sgg_tertiary_active_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'Selected options background color',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3f16ab4f7',
			'label' => 'Options Selected Text Color',
			'name' => 'sgg_tertiary_active_text_color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'Selected options text color',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3ecdab4e2',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_64ce3ebfab1e1',
			'label' => 'Spacing',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce3ed7ab1e2',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Spacing</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce3d01ab4d3',
			'label' => 'Step Density',
			'name' => 'sgg_configurator_step_density',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'default' => 'Default',
				'compact' => 'Compact',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4042f7a11',
			'label' => 'Configurator form width',
			'name' => 'sgg_template_form_options_width',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally override default form options width. Enter CSS units. Defaults to 540px',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4042f7a12',
			'label' => 'Configurator form width (tablet)',
			'name' => 'sgg_template_form_options_width_tablet',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally override default form options width for tablets. Enter CSS units. Defaults to 400px',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4042f7a13',
			'label' => 'Configurator form spacing',
			'name' => 'sgg_template_form_options_padding',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally override default form options spacing. Enter CSS units. Defaults to 50px',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4042f7a14',
			'label' => 'Configurator form spacing (tablet)',
			'name' => 'sgg_template_form_options_padding_tablet',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally override default form options spacing for tablets. Enter CSS units. Defaults to 40px',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4042f7d51',
			'label' => 'Attribute spacing top',
			'name' => 'sgg_attribute_spacing_top',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally override default attribute top spacing. Enter CSS units',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4042f7d53',
			'label' => 'Attribute spacing top (mobile)',
			'name' => 'sgg_attribute_spacing_top_mobile',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally override default attribute spacing top for mobile. Enter CSS units',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4042f7d52',
			'label' => 'Attribute spacing bottom',
			'name' => 'sgg_attribute_spacing_bottom',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally override default attribute spacing bottom. Enter CSS units',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4042f7d54',
			'label' => 'Attribute spacing bottom (mobile)',
			'name' => 'sgg_attribute_spacing_bottom_mobile',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally override default attribute spacing bottom for mobile. Enter CSS units',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce3ebfab1f1',
			'label' => 'Fonts',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce3ed7ab1f2',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Fonts</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce4042f7e10',
			'label' => 'Font Family',
			'name' => 'sgg_font_family',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'If you need a custom font, you should enter the font family name here (e.g. Helvetica).',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4042f7e11',
			'label' => 'Font Weight',
			'name' => 'sgg_font_weight',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter the font weight in CSS units (e.g. 700 or bold).',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4042f7e12',
			'label' => 'Font Style',
			'name' => 'sgg_font_style',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Select the font style here.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'normal' => 'Normal',
				'italic' => 'Italic',
			),
			'default_value' => false,
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_64ce405ff7d85',
			'label' => 'Font Scripts',
			'name' => 'sgg_header_scripts',
			'aria-label' => '',
			'type' => 'textarea',
			'instructions' => 'If you need to add scripts to your header (like Google Font scripts), you should enter them here.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'rows' => '',
			'placeholder' => '',
			'new_lines' => '',
		),
		array(
			'key' => 'field_64ce4be9cc616',
			'label' => 'Separator',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce4be9cc617',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Separator</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce4c2fcc618',
			'label' => 'Separator template',
			'name' => 'sgg_configurator_step_indicator',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'one' => 'Separator One',
				'two' => 'Separator Two',
				'three' => 'Separator Three',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4d69cc62f',
			'label' => 'Summary',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce4d69cc62a',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Summary</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce4d69cc62b',
			'label' => 'Display summary of selected configuration options',
			'name' => 'sgg_configurator_display_summary',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4d69cc62c',
			'label' => 'Summary title',
			'name' => 'sgg_configurator_summary_title',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Title that is displayed above the selected options list',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d69cc62b',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => 'Your configuration',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4d69cc62d',
			'label' => 'Summary empty message',
			'name' => 'sgg_configurator_summary_empty_message',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Message that appears when no option is selected',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d69cc62b',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => 'No options selected',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4d69cc62e',
			'label' => 'Summary location',
			'name' => 'sgg_configurator_summary_location',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d69cc62b',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'before_totals' => 'Before configurator totals',
				'after_totals' => 'After configurator totals',
				'new_page' =>'Replace configurator contents with summary page',
				'shortcode' => 'Anywhere using the shortcode',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4d69cc64b',
			'label' => 'Include attribute option notes in summary',
			'name' => 'sgg_configurator_summary_include_notes',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Extend summary details by including option notes',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d69cc62b',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4d69cc63a',
			'label' => 'Summary hidden attributes',
			'name' => 'sgg_configurator_summary_hidden_items',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally enter labels of attributes that should not be included in summary list (comma separated)',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d69cc62b',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4d69cc61e',
			'label' => 'Configurator button',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce4d69cc61f',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Configurator button</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce4d74cc620',
			'label' => 'Configurator button type',
			'name' => 'sgg_configurator_button_type',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'cart' => 'Add to cart',
				'invoice' => 'Request Quote',
				'email' => 'Send configuration via email',
				'none' => 'No action'
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce5069cc636',
			'label' => 'Close popup on totals configurator button click',
			'name' => 'sgg_configurator_button_close_popup',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Closes the popup and updates product page details based on configured product instead of adding to cart',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'popup',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5069cc637',
			'label' => 'Replace cart form with configure button',
			'name' => 'sgg_configurator_popup_replace_cart_form',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Replaces the single product page add to cart form with configure button',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'popup',
					),
					array(
						'field' => 'field_64ce5069cc636',
						'operator' => '==',
						'value' => '0',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4fdacc62f',
			'label' => 'Configurator Button Text',
			'name' => 'sgg_step_add_to_cart_text',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce5069cc699',
			'label' => 'Hide total button',
			'name' => 'sgg_configurator_hide_totals_button',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Hides the total button so no action is involved in the configurator. For configuration purposes only',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'invoice',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5069cc719',
			'label' => 'Email recipient',
			'name' => 'sgg_configurator_button_email_recipient',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally set the email adress of the receiver. Defaults to admin email',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'email',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce5069cc729',
			'label' => 'Email subject',
			'name' => 'sgg_configurator_button_email_subject',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally set a default email subject',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'email',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce5069cd724',
			'label' => 'Include product title in email body',
			'name' => 'sgg_configurator_button_email_show_product_title',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Includes product title in email contents',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'email',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5069ce856',
			'label' => 'Generate configuration image link',
			'name' => 'sgg_configurator_total_generate_image',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Generates a configuration image link to be used in form or email contents.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'invoice',
					),
				),
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'email',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4ffecc634',
			'label' => 'Request quote form display',
			'name' => 'sgg_configurator_form_display',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'invoice',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'page' => 'Separate page',
				'inline' => 'Inline in form',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4f8bcc62e',
			'label' => 'Form page',
			'name' => 'sgg_configurator_form_page',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Page where the form is located (user is redirected to this page).',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'invoice',
					),
					array(
						'field' => 'field_64ce4ffecc634',
						'operator' => '==',
						'value' => 'page',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'page',
			),
			'post_status' => '',
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4f8bcc62g',
			'label' => 'Form shortcode',
			'name' => 'sgg_configurator_form_shortcode',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter form shortcode.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'invoice',
					),
					array(
						'field' => 'field_64ce4ffecc634',
						'operator' => '==',
						'value' => 'inline',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce5069cc645',
			'label' => 'Show totals button when all required options are selected',
			'name' => 'sgg_configurator_step_totals_display_required',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5069cc649',
			'label' => 'Hide buttons when they are disabled',
			'name' => 'sgg_configurator_step_buttons_hide_disabled',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5069cc633',
			'label' => 'Make total action button sticky',
			'name' => 'sgg_configurator_sticky_button',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4ffecc630',
						'operator' => '==',
						'value' => 'always',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '!=',
						'value' => 'steps',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '!=',
						'value' => 'popup',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce50cccc634',
			'label' => 'Make add to cart button sticky on mobile',
			'name' => 'sgg_configurator_sticky_button_mobile',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'steps',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce4d69cc69e',
			'label' => 'Configurator price',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce4d69cc69f',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Configurator price</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce4d91cc621',
			'label' => 'Configurator total price calculation',
			'name' => 'sgg_configurator_total_calculation',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'default' => 'Default calculation',
				'custom' => 'Formula calculation',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4dbdcc622',
			'label' => 'Total price formula',
			'name' => 'sgg_configurator_total_price_formula',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Insert custom formula to calculate total price.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d91cc621',
						'operator' => '==',
						'value' => 'custom',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4df9cc624',
			'label' => 'Display totals',
			'name' => 'sgg_configurator_display_pricing',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'show' => 'Show total price',
				'hide' => 'Hide total price',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4e22cc625',
			'label' => 'Total price display',
			'name' => 'sgg_configurator_total_price_display',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'cart',
					),
				),
				array(
					array(
						'field' => 'field_64ce4df9cc624',
						'operator' => '==',
						'value' => 'show',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'within' => 'In button',
				'above' => 'Above button',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4ebecc627',
			'label' => 'Price display template',
			'name' => 'sgg_configurator_price_display_template',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4e22cc625',
						'operator' => '==',
						'value' => 'above',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '!=',
						'value' => 'steps',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '!=',
						'value' => 'popup',
					),
				),
				array(
					array(
						'field' => 'field_64ce4df9cc624',
						'operator' => '==',
						'value' => 'show',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '!=',
						'value' => 'steps',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '!=',
						'value' => 'popup',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'total' => 'Only total configuration price',
				'summary' => 'Display total configuration price breakdown',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'vertical',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce4dbdcc62a',
			'label' => 'Product total label',
			'name' => 'sgg_configurator_totals_product_label',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4ebecc627',
						'operator' => '==',
						'value' => 'summary',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => 'Product total:',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4dbdcc62b',
			'label' => 'Options total label',
			'name' => 'sgg_configurator_totals_options_label',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4ebecc627',
						'operator' => '==',
						'value' => 'summary',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => 'Options total:',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4dbdcc62c',
			'label' => 'Grand total label',
			'name' => 'sgg_configurator_totals_combined_label',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4ebecc627',
						'operator' => '==',
						'value' => 'summary',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => 'Grand total:',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce4dbdcc62d',
			'label' => 'Total label',
			'name' => 'sgg_configurator_totals_label',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4e22cc625',
						'operator' => '==',
						'value' => 'above',
					),
					array(
						'field' => 'field_64ce4df9cc624',
						'operator' => '==',
						'value' => 'show',
					),
					array(
						'field' => 'field_64ce4ebecc627',
						'operator' => '!=',
						'value' => 'summary',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => 'Total:',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce5069cc629',
			'label' => 'Collapse price summary on mobile',
			'name' => 'sgg_configurator_price_summary_collapse',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Make price summary collapsible on mobile devices to save space',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4e22cc625',
						'operator' => '==',
						'value' => 'above',
					),
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => 'IN',
						'value' => array( 'classic', 'floating', 'full' ),
					),
					array(
						'field' => 'field_64ce4ebecc627',
						'operator' => '==',
						'value' => 'summary',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce3ccd34edb',
			'label' => 'Configurator extras',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce3ccd34edc',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Configurator extras</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce5b8aef551',
			'label' => 'Display product quantity Input',
			'name' => 'sgg_configurator_display_qty_input',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'cart',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5b8aef554',
			'label' => 'Product Quantity Input Name',
			'name' => 'sgg_configurator_qty_input_label',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Optionally enter name of input to function as the main product quantity input',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'cart',
					),
					array(
						'field' => 'field_64ce5b8aef551',
						'operator' => '==',
						'value' => '0',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_64ce5b8aef552',
			'label' => 'Multiply total price by quantity',
			'name' => 'sgg_configurator_display_qty_total',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'When checked the total configurator price will be shown as price * quantity',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'cart',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5bd1ef597',
			'label' => 'Display sticky add to cart bar',
			'name' => 'sgg_configurator_sticky_cart_bar',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce3a70671de',
						'operator' => '==',
						'value' => 'classic',
					),
					array(
						'field' => 'field_64ce4d74cc620',
						'operator' => '==',
						'value' => 'cart',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce5bd1ef598',
			'label' => 'Display USPs in sticky bar',
			'name' => 'sgg_configurator_sticky_cart_bar_usps',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_64ce5bd1ef597',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_64ce3e22ab4dd',
			'label' => 'USPs location',
			'name' => 'sgg_configurator_usp_location',
			'aria-label' => '',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'totals' => 'Totals',
				'gallery' => 'Gallery',
			),
			'default_value' => '',
			'return_format' => 'value',
			'allow_null' => 0,
			'other_choice' => 0,
			'layout' => 'horizontal',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_64ce3e39ab4de',
			'label' => 'Unique Selling Points',
			'name' => 'sgg_step_usps',
			'aria-label' => '',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'table',
			'pagination' => 0,
			'min' => 0,
			'max' => 3,
			'collapsed' => '',
			'button_label' => 'Add USP',
			'rows_per_page' => 20,
			'sub_fields' => array(
				array(
					'key' => 'field_64ce3e66ab4df',
					'label' => 'Icon',
					'name' => 'sgg_usp_icon',
					'aria-label' => '',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'id',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '.jpg, .jpeg, .png, .tiff, .svg, .webp, .eps',
					'preview_size' => 'thumbnail',
					'parent_repeater' => 'field_64ce3e39ab4de',
				),
				array(
					'key' => 'field_64ce3e8dab4e0',
					'label' => 'Title',
					'name' => 'sgg_usp_title',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'parent_repeater' => 'field_64ce3e39ab4de',
				),
			),
		),
		array(
			'key' => 'field_64ce40fff7d86',
			'label' => 'Custom CSS',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
		),
		array(
			'key' => 'field_64ce40fff7d87',
			'label' => '',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<h3>Custom CSS</h3>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_64ce4109f7d88',
			'label' => 'Custom styles',
			'name' => 'sgg_configurator_css',
			'aria-label' => '',
			'type' => 'textarea',
			'instructions' => 'If you need to add custom configurator styling, you should enter the CSS here.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => 'editor-css',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'rows' => 20,
			'placeholder' => '',
			'new_lines' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'sgg_theme',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'field',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );
